﻿using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace HIPS.Web.Test
{

    /// <summary>
    /// Base class for unit tests.
    /// </summary>
    /// <history>
    ///     <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
    /// </history>
    [TestClass]
    public abstract class TestBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the unit testing TestContext.
        /// </summary>
        /// <history>
        ///     <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public TestContext TestContext { get; set; }

        #endregion

        #region Methods

        /// <summary>
        /// Get the XML string representation of the provided object.
        /// </summary>
        /// <param name="source">Source object.</param>
        /// <returns>String containing the XML representation of the source object.</returns>
        /// <history>
        ///     <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        protected string GetObjectXmlString(object source)
        {
            var writer = new System.IO.StringWriter();
            var serializer = new System.Xml.Serialization.XmlSerializer(source.GetType());
            serializer.Serialize(writer, source);

            return writer.ToString();
        }

        #endregion

    }
}
